﻿using System;
using NetOffice;
using NetOffice.Attributes;
namespace NetOffice.WordApi.Enums
{
	 /// <summary>
	 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
	 /// </summary>
	 ///<remarks> MSDN Online Documentation: http://msdn.microsoft.com/en-us/en-us/library/office/ff834937.aspx </remarks>
	[SupportByVersion("Word", 9,10,11,12,14,15,16)]
	[EntityType(EntityType.IsEnum)]
	public enum WdLanguageID
	{
		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>0</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdLanguageNone = 0,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1024</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdNoProofing = 1024,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1078</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdAfrikaans = 1078,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1052</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdAlbanian = 1052,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>5121</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdArabicAlgeria = 5121,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>15361</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdArabicBahrain = 15361,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>3073</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdArabicEgypt = 3073,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>2049</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdArabicIraq = 2049,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>11265</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdArabicJordan = 11265,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>13313</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdArabicKuwait = 13313,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>12289</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdArabicLebanon = 12289,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>4097</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdArabicLibya = 4097,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>6145</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdArabicMorocco = 6145,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>8193</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdArabicOman = 8193,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>16385</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdArabicQatar = 16385,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1025</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdArabic = 1025,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>10241</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdArabicSyria = 10241,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>7169</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdArabicTunisia = 7169,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>14337</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdArabicUAE = 14337,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>9217</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdArabicYemen = 9217,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1067</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdArmenian = 1067,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1101</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdAssamese = 1101,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>2092</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdAzeriCyrillic = 2092,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1068</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdAzeriLatin = 1068,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1069</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdBasque = 1069,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1059</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdByelorussian = 1059,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1093</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdBengali = 1093,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1026</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdBulgarian = 1026,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1109</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdBurmese = 1109,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1027</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdCatalan = 1027,

		 /// <summary>
		 /// SupportByVersion Word 9
		 /// </summary>
		 /// <remarks>3076</remarks>
		 [SupportByVersion("Word", 9)]
		 wdChineseHongKong = 3076,

		 /// <summary>
		 /// SupportByVersion Word 9
		 /// </summary>
		 /// <remarks>5124</remarks>
		 [SupportByVersion("Word", 9)]
		 wdChineseMacao = 5124,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>2052</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdSimplifiedChinese = 2052,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>4100</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdChineseSingapore = 4100,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1028</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdTraditionalChinese = 1028,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1050</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdCroatian = 1050,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1029</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdCzech = 1029,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1030</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDanish = 1030,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>2067</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdBelgianDutch = 2067,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1043</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdDutch = 1043,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>3081</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdEnglishAUS = 3081,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>10249</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdEnglishBelize = 10249,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>4105</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdEnglishCanadian = 4105,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>9225</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdEnglishCaribbean = 9225,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>6153</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdEnglishIreland = 6153,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>8201</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdEnglishJamaica = 8201,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>5129</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdEnglishNewZealand = 5129,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>13321</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdEnglishPhilippines = 13321,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>7177</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdEnglishSouthAfrica = 7177,

		 /// <summary>
		 /// SupportByVersion Word 9
		 /// </summary>
		 /// <remarks>11273</remarks>
		 [SupportByVersion("Word", 9)]
		 wdEnglishTrinidad = 11273,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>2057</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdEnglishUK = 2057,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1033</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdEnglishUS = 1033,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>12297</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdEnglishZimbabwe = 12297,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1061</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdEstonian = 1061,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1080</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdFaeroese = 1080,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11
		 /// </summary>
		 /// <remarks>1065</remarks>
		 [SupportByVersion("Word", 9,10,11)]
		 wdFarsi = 1065,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1035</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdFinnish = 1035,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>2060</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdBelgianFrench = 2060,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>11276</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdFrenchCameroon = 11276,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>3084</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdFrenchCanadian = 3084,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>12300</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdFrenchCotedIvoire = 12300,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1036</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdFrench = 1036,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>5132</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdFrenchLuxembourg = 5132,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>13324</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdFrenchMali = 13324,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>6156</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdFrenchMonaco = 6156,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>8204</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdFrenchReunion = 8204,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>10252</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdFrenchSenegal = 10252,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>4108</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdSwissFrench = 4108,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>7180</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdFrenchWestIndies = 7180,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11
		 /// </summary>
		 /// <remarks>9228</remarks>
		 [SupportByVersion("Word", 9,10,11)]
		 wdFrenchZaire = 9228,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1122</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdFrisianNetherlands = 1122,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>2108</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdGaelicIreland = 2108,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1084</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdGaelicScotland = 1084,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1110</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdGalician = 1110,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1079</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdGeorgian = 1079,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>3079</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdGermanAustria = 3079,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1031</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdGerman = 1031,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>5127</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdGermanLiechtenstein = 5127,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>4103</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdGermanLuxembourg = 4103,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>2055</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdSwissGerman = 2055,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1032</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdGreek = 1032,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1095</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdGujarati = 1095,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1037</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdHebrew = 1037,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1081</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdHindi = 1081,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1038</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdHungarian = 1038,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1039</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdIcelandic = 1039,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1057</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdIndonesian = 1057,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1040</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdItalian = 1040,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>2064</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdSwissItalian = 2064,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1041</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdJapanese = 1041,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1099</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdKannada = 1099,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1120</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdKashmiri = 1120,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1087</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdKazakh = 1087,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1107</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdKhmer = 1107,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1088</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdKirghiz = 1088,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1111</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdKonkani = 1111,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1042</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdKorean = 1042,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1108</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdLao = 1108,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1062</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdLatvian = 1062,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1063</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdLithuanian = 1063,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11
		 /// </summary>
		 /// <remarks>1071</remarks>
		 [SupportByVersion("Word", 9,10,11)]
		 wdMacedonian = 1071,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1086</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdMalaysian = 1086,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>2110</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdMalayBruneiDarussalam = 2110,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1100</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdMalayalam = 1100,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1082</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdMaltese = 1082,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1112</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdManipuri = 1112,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1102</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdMarathi = 1102,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1104</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdMongolian = 1104,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1121</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdNepali = 1121,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1044</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdNorwegianBokmol = 1044,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>2068</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdNorwegianNynorsk = 2068,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1096</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdOriya = 1096,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1045</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdPolish = 1045,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11
		 /// </summary>
		 /// <remarks>1046</remarks>
		 [SupportByVersion("Word", 9,10,11)]
		 wdBrazilianPortuguese = 1046,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>2070</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdPortuguese = 2070,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1094</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdPunjabi = 1094,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1047</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdRhaetoRomanic = 1047,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>2072</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdRomanianMoldova = 2072,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1048</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdRomanian = 1048,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>2073</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdRussianMoldova = 2073,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1049</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdRussian = 1049,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1083</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdSamiLappish = 1083,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1103</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdSanskrit = 1103,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>3098</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdSerbianCyrillic = 3098,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>2074</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdSerbianLatin = 2074,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1113</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdSindhi = 1113,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1051</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdSlovak = 1051,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1060</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdSlovenian = 1060,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1070</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdSorbian = 1070,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>11274</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdSpanishArgentina = 11274,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>16394</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdSpanishBolivia = 16394,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>13322</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdSpanishChile = 13322,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>9226</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdSpanishColombia = 9226,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>5130</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdSpanishCostaRica = 5130,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>7178</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdSpanishDominicanRepublic = 7178,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>12298</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdSpanishEcuador = 12298,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>17418</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdSpanishElSalvador = 17418,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>4106</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdSpanishGuatemala = 4106,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>18442</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdSpanishHonduras = 18442,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>2058</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdMexicanSpanish = 2058,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>19466</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdSpanishNicaragua = 19466,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>6154</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdSpanishPanama = 6154,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>15370</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdSpanishParaguay = 15370,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>10250</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdSpanishPeru = 10250,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>20490</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdSpanishPuertoRico = 20490,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>3082</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdSpanishModernSort = 3082,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1034</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdSpanish = 1034,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>14346</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdSpanishUruguay = 14346,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>8202</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdSpanishVenezuela = 8202,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1072</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdSesotho = 1072,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1072</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdSutu = 1072,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1089</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdSwahili = 1089,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>2077</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdSwedishFinland = 2077,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1053</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdSwedish = 1053,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1064</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdTajik = 1064,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1097</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdTamil = 1097,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1092</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdTatar = 1092,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1098</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdTelugu = 1098,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1054</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdThai = 1054,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1105</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdTibetan = 1105,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1073</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdTsonga = 1073,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1074</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdTswana = 1074,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1055</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdTurkish = 1055,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1090</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdTurkmen = 1090,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1058</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdUkrainian = 1058,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1056</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdUrdu = 1056,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>2115</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdUzbekCyrillic = 2115,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1091</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdUzbekLatin = 1091,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1075</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdVenda = 1075,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1066</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdVietnamese = 1066,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1106</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdWelsh = 1106,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1076</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdXhosa = 1076,

		 /// <summary>
		 /// SupportByVersion Word 9, 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1077</remarks>
		 [SupportByVersion("Word", 9,10,11,12,14,15,16)]
		 wdZulu = 1077,

		 /// <summary>
		 /// SupportByVersion Word 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1118</remarks>
		 [SupportByVersion("Word", 10,11,12,14,15,16)]
		 wdAmharic = 1118,

		 /// <summary>
		 /// SupportByVersion Word 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1116</remarks>
		 [SupportByVersion("Word", 10,11,12,14,15,16)]
		 wdCherokee = 1116,

		 /// <summary>
		 /// SupportByVersion Word 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>3076</remarks>
		 [SupportByVersion("Word", 10,11,12,14,15,16)]
		 wdChineseHongKongSAR = 3076,

		 /// <summary>
		 /// SupportByVersion Word 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>5124</remarks>
		 [SupportByVersion("Word", 10,11,12,14,15,16)]
		 wdChineseMacaoSAR = 5124,

		 /// <summary>
		 /// SupportByVersion Word 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1125</remarks>
		 [SupportByVersion("Word", 10,11,12,14,15,16)]
		 wdDivehi = 1125,

		 /// <summary>
		 /// SupportByVersion Word 10, 11
		 /// </summary>
		 /// <remarks>2129</remarks>
		 [SupportByVersion("Word", 10,11)]
		 wdDzongkhaBhutan = 2129,

		 /// <summary>
		 /// SupportByVersion Word 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1126</remarks>
		 [SupportByVersion("Word", 10,11,12,14,15,16)]
		 wdEdo = 1126,

		 /// <summary>
		 /// SupportByVersion Word 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>11273</remarks>
		 [SupportByVersion("Word", 10,11,12,14,15,16)]
		 wdEnglishTrinidadTobago = 11273,

		 /// <summary>
		 /// SupportByVersion Word 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>14345</remarks>
		 [SupportByVersion("Word", 10,11,12,14,15,16)]
		 wdEnglishIndonesia = 14345,

		 /// <summary>
		 /// SupportByVersion Word 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1124</remarks>
		 [SupportByVersion("Word", 10,11,12,14,15,16)]
		 wdFilipino = 1124,

		 /// <summary>
		 /// SupportByVersion Word 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1127</remarks>
		 [SupportByVersion("Word", 10,11,12,14,15,16)]
		 wdFulfulde = 1127,

		 /// <summary>
		 /// SupportByVersion Word 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>14348</remarks>
		 [SupportByVersion("Word", 10,11,12,14,15,16)]
		 wdFrenchMorocco = 14348,

		 /// <summary>
		 /// SupportByVersion Word 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>15372</remarks>
		 [SupportByVersion("Word", 10,11,12,14,15,16)]
		 wdFrenchHaiti = 15372,

		 /// <summary>
		 /// SupportByVersion Word 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1140</remarks>
		 [SupportByVersion("Word", 10,11,12,14,15,16)]
		 wdGuarani = 1140,

		 /// <summary>
		 /// SupportByVersion Word 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1128</remarks>
		 [SupportByVersion("Word", 10,11,12,14,15,16)]
		 wdHausa = 1128,

		 /// <summary>
		 /// SupportByVersion Word 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1141</remarks>
		 [SupportByVersion("Word", 10,11,12,14,15,16)]
		 wdHawaiian = 1141,

		 /// <summary>
		 /// SupportByVersion Word 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1129</remarks>
		 [SupportByVersion("Word", 10,11,12,14,15,16)]
		 wdIbibio = 1129,

		 /// <summary>
		 /// SupportByVersion Word 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1136</remarks>
		 [SupportByVersion("Word", 10,11,12,14,15,16)]
		 wdIgbo = 1136,

		 /// <summary>
		 /// SupportByVersion Word 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1117</remarks>
		 [SupportByVersion("Word", 10,11,12,14,15,16)]
		 wdInuktitut = 1117,

		 /// <summary>
		 /// SupportByVersion Word 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1137</remarks>
		 [SupportByVersion("Word", 10,11,12,14,15,16)]
		 wdKanuri = 1137,

		 /// <summary>
		 /// SupportByVersion Word 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1088</remarks>
		 [SupportByVersion("Word", 10,11,12,14,15,16)]
		 wdKyrgyz = 1088,

		 /// <summary>
		 /// SupportByVersion Word 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1142</remarks>
		 [SupportByVersion("Word", 10,11,12,14,15,16)]
		 wdLatin = 1142,

		 /// <summary>
		 /// SupportByVersion Word 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1138</remarks>
		 [SupportByVersion("Word", 10,11,12,14,15,16)]
		 wdOromo = 1138,

		 /// <summary>
		 /// SupportByVersion Word 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1123</remarks>
		 [SupportByVersion("Word", 10,11,12,14,15,16)]
		 wdPashto = 1123,

		 /// <summary>
		 /// SupportByVersion Word 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1115</remarks>
		 [SupportByVersion("Word", 10,11,12,14,15,16)]
		 wdSinhalese = 1115,

		 /// <summary>
		 /// SupportByVersion Word 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>2137</remarks>
		 [SupportByVersion("Word", 10,11,12,14,15,16)]
		 wdSindhiPakistan = 2137,

		 /// <summary>
		 /// SupportByVersion Word 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1143</remarks>
		 [SupportByVersion("Word", 10,11,12,14,15,16)]
		 wdSomali = 1143,

		 /// <summary>
		 /// SupportByVersion Word 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1114</remarks>
		 [SupportByVersion("Word", 10,11,12,14,15,16)]
		 wdSyriac = 1114,

		 /// <summary>
		 /// SupportByVersion Word 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1119</remarks>
		 [SupportByVersion("Word", 10,11,12,14,15,16)]
		 wdTamazight = 1119,

		 /// <summary>
		 /// SupportByVersion Word 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>2143</remarks>
		 [SupportByVersion("Word", 10,11,12,14,15,16)]
		 wdTamazightLatin = 2143,

		 /// <summary>
		 /// SupportByVersion Word 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1139</remarks>
		 [SupportByVersion("Word", 10,11,12,14,15,16)]
		 wdTigrignaEthiopic = 1139,

		 /// <summary>
		 /// SupportByVersion Word 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>2163</remarks>
		 [SupportByVersion("Word", 10,11,12,14,15,16)]
		 wdTigrignaEritrea = 2163,

		 /// <summary>
		 /// SupportByVersion Word 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1144</remarks>
		 [SupportByVersion("Word", 10,11,12,14,15,16)]
		 wdYi = 1144,

		 /// <summary>
		 /// SupportByVersion Word 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1085</remarks>
		 [SupportByVersion("Word", 10,11,12,14,15,16)]
		 wdYiddish = 1085,

		 /// <summary>
		 /// SupportByVersion Word 10, 11, 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1130</remarks>
		 [SupportByVersion("Word", 10,11,12,14,15,16)]
		 wdYoruba = 1130,

		 /// <summary>
		 /// SupportByVersion Word 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1065</remarks>
		 [SupportByVersion("Word", 12,14,15,16)]
		 wdPersian = 1065,

		 /// <summary>
		 /// SupportByVersion Word 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>9228</remarks>
		 [SupportByVersion("Word", 12,14,15,16)]
		 wdFrenchCongoDRC = 9228,

		 /// <summary>
		 /// SupportByVersion Word 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1071</remarks>
		 [SupportByVersion("Word", 12,14,15,16)]
		 wdMacedonianFYROM = 1071,

		 /// <summary>
		 /// SupportByVersion Word 12, 14, 15, 16
		 /// </summary>
		 /// <remarks>1046</remarks>
		 [SupportByVersion("Word", 12,14,15,16)]
		 wdPortugueseBrazil = 1046
	}
}